;/***********************************************/
;/*		}N` 			*/
;/***********************************************/

PUSHALL	MACRO
	PUSH	AF
	PUSH	BC
	PUSH	DE
	PUSH	HL
	ENDM



POPALL	MACRO
	POP	HL
	POP	DE
	POP	BC
	POP	AF
	ENDM



ADD16	MACRO	OPE1,OPE2,OPE3
	PUSH	AF
	LD	A,OPE2
	ADD	A,OPE3
	LD	OPE2,A
	LD	A,OPE1
	ADC	A,0
	LD	OPE1,A
	POP	AF
	ENDM


; OPE1 = OPE2		(LOAD MEMORY)
LDM	MACRO	OPE1,OPE2
	LD	A,OPE2
	LD	OPE1,A
	ENDM


; OPE1 = OPE1 + OPE2	(BREAK A)
ADD2	MACRO	OPE1,OPE2
	LD	A,OPE1
	ADD	A,OPE2
	LD	OPE1,A
	ENDM



ADDM	MACRO	OPE3,OPE1,OPE2		; OPE3 = OPE1 + OPE2	(ADD MEMORY)
	PUSH	AF
	PUSH	BC
	LD	A,OPE2
	LD	B,A
	LD	A,OPE1
	ADD	A,B
	LD	OPE3,A
	POP	BC
	POP	AF
	ENDM



SUBM	MACRO	OPE3,OPE1,OPE2
	PUSH	AF
	PUSH	BC
	LD	A,OPE2
	LD	B,A
	LD	A,OPE1
	SUB	B
	LD	OPE3,A
	POP	BC
	POP	AF
	ENDM



INCM	MACRO	OPE1			; OPE1 = OPE1 + 1	(INC MEMORY)
	LD	A,OPE1
	INC	A
	LD	OPE1,A
	ENDM



DECM	MACRO	OPE1			; OPE1 = OPE1 - 1 	(DEC MEMORY)
	LD	A,OPE1
	DEC	A
	LD	OPE1,A
	ENDM



ADDW	MACRO	OPE1,OPE2		; OPE1 = OPE1 + OPE2	(16 BIT ADD)
	PUSH	AF
	LD	A,(OPE1)
	ADD	A,OPE2
	LD	(OPE1),A
	LD	A,(OPE1+1)
	ADC	A,0
	LD	(OPE1+1),A
	POP	AF
	ENDM



SUBW	MACRO	OPE1,OPE2		; OPE1 = OPE1 - OPE2	(16 BIT SUB)
	PUSH	AF
	LD	A,(OPE1)
	SUB	OPE2
	LD	(OPE1),A
	LD	A,(OPE1+1)
	SBC	A,0
	LD	(OPE1+1),A
	POP	AF
	ENDM



RNG_CHK	MACRO	OPE1,MIN,MAX		; OPE1  ͈͂  (BREAK A)
	LD	A,OPE1
	CP	MIN
	DEFB	$30,$05
	LDM	OPE1,MIN
	CP	MAX
	DEFB	$38,$05
	LDM	OPE1,MAX
	ENDM



OBJPUT1	MACRO	X,Y,CHR_CODE,OBJ_NO	; 8 * 8 DOT IuWFg\
	PUSHALL
	LDM	C,CHR_CODE
	LDM	D,X
	LDM	E,Y
	LD	A,OBJ_NO
	CALL	OBJPUT1
	POPALL
	ENDM



RAMFILL	MACRO	ST_ADDR,EN_ADDR,CODE	; [ CODE ߂
	LD	HL,ST_ADDR
	LD	DE,EN_ADDR
	LD	B,CODE
	INC	DE
	CALL	RAMFILL
	ENDM



WAIT	MACRO	N			; N t[\tgEFCg
	LD	BC,N
	CALL	WAIT
	ENDM



JOYPAD	MACRO	OPE1			; OPE1 ړpxNg(JX,JY)쐬
	LD	A,OPE1
	CALL	JOYPAD
	ENDM



;/**********************************************/
;/*      	Tu[`                   */
;/**********************************************/

;/************* JOYPAD *************************/

JOYPAD	LD	B,A
	LDM	(JX),0
	LDM	(JY),0
	SCF
	CCF
	BIT	4,B
	JR	Z,JOYPAD10
	LDM	(JX),1
	SCF
JOYPAD10
	BIT	5,B
	JR	Z,JOYPAD20
	LDM	(JX),255
	SCF
JOYPAD20
	BIT	6,B
	JR	Z,JOYPAD30
	LDM	(JY),255
	SCF
JOYPAD30
	BIT	7,B
	JR	Z,JOYPAD40
	LDM	(JY),1
	SCF
JOYPAD40
	RET



;/************	RAMFILL ************************/

RAMFILL
	LD	A,B
	LD	(HLI),A
	LD	A,H
	CP	D
	JR	NZ,RAMFILL
	LD	A,L
	CP	E
	JR	NZ,RAMFILL
	RET



;/*************	WAIT ***************************/

WAIT
	LD	DE,1750
WAIT00
	NOP			;1
	NOP			;1
	NOP			;1
	DEC	DE		;2
	LD	A,D		;1
	OR	E		;1
	JR	NZ,WAIT00	;3  v10TCN
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,WAIT
	RET



;/************* OBJPUT1 **************************/

OBJPUT1
	SLA	A
	SLA	A
	LD	HL,OBJRAM
	LD	L,A

	LDM	(HLI),E
	LDM	(HLI),D
	LDM	(HLI),C
	LDM	(HLI),$90
	RET



;/************* OBJPUT2 **************************/

OBJPUT2
	SLA	A
	SLA	A
	LD	HL,OBJRAM
	LD	L,A

	LDM	(HLI),E
	LDM	(HLI),D
	LDM	(HLI),C
	LDM	(HLI),$00

	INC	C
	LD	B,D
	ADD2	B,8
	LDM	(HLI),E
	LDM	(HLI),B
	LDM	(HLI),C
	LDM	(HLI),$00

	ADD2	C,15
	ADD2	E,8
	LDM	(HLI),E
	LDM	(HLI),D
	LDM	(HLI),C
	LDM	(HLI),$00

	INC	C
	LDM	(HLI),E
	LDM	(HLI),B
	LDM	(HLI),C
	LDM	(HLI),$00

	RET



;/************* OBJPUT3 **************************/

OBJPUT3
	SLA	A
	SLA	A
	LD	HL,OBJRAM
	LD	L,A

	LD	B,D
	ADD2	B,8
	LDM	(HLI),E
	LDM	(HLI),B
	LDM	(HLI),C
	LDM	(HLI),$20

	INC	C
	LDM	(HLI),E
	LDM	(HLI),D
	LDM	(HLI),C
	LDM	(HLI),$20

	ADD2	C,15
	ADD2	E,8
	LDM	(HLI),E
	LDM	(HLI),B
	LDM	(HLI),C
	LDM	(HLI),$20

	INC	C
	LDM	(HLI),E
	LDM	(HLI),D
	LDM	(HLI),C
	LDM	(HLI),$20

	RET



;/************  WAIT_NMI ************************/

VB_WAIT
	LD	A,(VBLANK_F)	; u|ak`mj ҂
	AND	A
	JR	Z,VB_WAIT

	XOR	A
	LD	(VBLANK_F),A
	RET



;/************  OBJ_CLS ************************/

OBJ_CLS
	LD	B,$A0			; nai q`l NA
	LD	A,0
	LD	HL,OBJRAM
OBJ_CLS00
	LD	(HLI),A
	DEC	B
	JR	NZ,OBJ_CLS00
	RET



;************************************************
;*	Q[{[C Tu[` 		*
;*	                       			*
;*		Start on 1988N11 10	*
;*		modify on 1989N 1 27	*
;************************************************

;
;--------------------------------------------------------------------
;-   CONT	        L|̓|`			    -
;-								    -
;-	dmsqx						    -
;-	   							    -
;-								    -
;-	qdstqm						    -
;-	   CNT1 = |Nq`l	; ׂ͕ێp	    -
;-	   TRG1 = |Nq`l	; gK͕ێp	    -
;-								    -
;-	   gpWX^  `CaCb				    -
;-								    -
;--------------------------------------------------------------------
;     		******************************
;     		*                            *
;     		*     7                      *
;     		*  6     5   3  4    2   1   *
;     		*     8			     *
;     		*			     *
;     		******************************
CONT	LD	A,$20
	LD	(P1),A
	LD	A,(P1)
	LD	A,(P1)
	CPL

	AND	$0F
	SWAP	A
	LD	B,A
	LD	A,$30
	LD	(P1),A
	LD	A,$10
	LD	(P1),A
	LD	A,(P1)
	LD	A,(P1)
	LD	A,(P1)
	LD	A,(P1)
	LD	A,(P1)
	LD	A,(P1)
	CPL
	AND	$0F
	OR	B
	LD	C,A
	LD	A,(CNT1)
	XOR	C
	AND	C
	LD	(TRG1),A
	LD	A,C
	LD	(CNT1),A
;
	LD	A,$30
	LD	(P1),A
	RET

	PAGE
;--------------------------------------------------------------------
;-   DMASET	cl`][`[Nq`lɓWJ      -
;-								    -
;-	  (   POoCggp    )				    -
;-								    -
;-								    -
;-	   eeWO		  	 ;  ݒu擪Ԓn	    -
;-	   bOOO	@ 		 ;  n`l擪Ԓn	    -
;-								    -
;-	   gpWX^  `CaCb				    -
;-								    -
;--------------------------------------------------------------------
;-   DMASUB		cl`][`			    -
;-								    -
;-	naiq`l($C000-$C09F) || n`l ($FE00-$FE9F)	    -
;-								    -
;-	dmsqx						    -
;-	   							    -
;-								    -
;-	qdstqm						    -
;-	   							    -
;-	P[V   DMASUB =  $FF80         			    -
;-								    -
;-	   gpWX^  `̂					    -
;-								    -
;--------------------------------------------------------------------
DMASET
	LD	C,$80
	LD	B,10		; DMADATA  POoCg
	LD	HL,DMADATA
L2	LD	A,(HLI)
	LD	(C),A
	INC	C
	DEC	B
	JR	NZ,L2
	RET

DMADATA				;       DMASUB ̓e
	DB	$3E,$D0		;	LD	A,LABEL2
	DB	$E0,$46		;	LD	(DMA),A
	DB	$3E,$28		;	LD	A,40	; 160TCN
	DB	$3D		; L1	DEC	A	;    EGCg
	DB	$20,$FD		;	JR	NZ,L1
	DB	$C9		;	RET


	PAGE
;--------------------------------------------------------------------
;-   OBJBG	naiWʒuɑΉuq`lAhXZo  -
;-								    -
;-	dmsqx						    -
;-	   OBJYP =  |Nq`l	 ; nai@xWێp	    -
;-	   OBJXP =  |Nq`l@ ; nai@wWێp	    -
;-								    -
;-	qdstqm						    -
;-	   VRAMH =  |Nq`l	 ;uq`lʃAhXێp-
;-	   VRAML =  |Nq`l	 ;uq`lʃAhXێp-
;-								    -
;-								    -
;-	   gpWX^  `CaCcdCgk			    -
;-								    -
;--------------------------------------------------------------------
OBJBG
	LD	A,(OBJYP)	;HL=(OBJY-20H)/8*020H+09841H
	SUB	$10		;
	SRL	A		;
	SRL	A		;
	SRL	A		;
	LD	DE,$000		;
	LD	E,A		;
	LD	HL,$09800	;
	LD	B,$020		;
OBJBG1	ADD	HL,DE		;
	DEC	B		;
	JR	NZ,OBJBG1	;---------------------

	LD	A,(OBJXP)	;DE=(OBJX-08H)/8
	SUB	$08		;
	SRL	A		;
	SRL	A		;
	SRL	A		;
	LD	DE,$000		;
	LD	E,A		;---------------------
	ADD	HL,DE		;HL=HL+DE
	LD	A,H		;SAVE TO VRAMH,VRAML
	LD	(VRAMH),A	;
	LD	A,L		;
	LD	(VRAML),A	;---------------------

	RET


	PAGE
;--------------------------------------------------------------------
;-   BGOBJ	uq`lAhXɂnaiWʒuΉZo  -
;-								    -
;-	dmsqx						    -
;-	   VRAMH =  |Nq`l	 ;uq`lʃAhXێp-
;-	   VRAML =  |Nq`l	 ;uq`lʃAhXێp-
;-								    -
;-	qdstqm						    -
;-	   OBJYP =  |Nq`l	 ; nai@xWێp	    -
;-	   OBJXP =  |Nq`l@ ; nai@wWێp	    -
;-								    -
;-		     LZbg				    -
;-								    -
;-	   gpWX^  `CaCcdCgk			    -
;-								    -
;--------------------------------------------------------------------
BGOBJ
	LD	A,(VRAMH)	;DE=VRAM ADDRESS
	LD	D,A		;
	LD	A,(VRAML)	;
	LD	E,A		;---------------
	LD	B,4		;DE R-SHIFT
BGOBJ1	RR	D		;    4 TIMES
	RR	E		;
	DEC	B		;
	JR	NZ,BGOBJ1	;---------------
	LD	A,E		;(E-084H)*4
	SUB	$084		;
	AND	$0FE		;
	RLCA			;
	RLCA			;---------------
	ADD	A,$08		;
	LD	(OBJYP),A	;SAVE TO OBJY

	LD	A,(VRAML)	;CALICURATE
	AND	$01F		;  OBJ H-POSITION
	RLA			;
	RLA			;
	RLA			;
	ADD	A,$08		;---------------
	LD	(OBJXP),A	;SAVE TO OBJX

	RET


	PAGE
;--------------------------------------------------------------------
;-   RST 0      	hcilo  				    -
;-								    -
;-								    -
;-	   AhXOOԒn    JP	IDJMP 	܂͉L	    -
;-	   vO𒼐ڐݒuĂ				    -
;-								    -
;-	dmsqx						    -
;-	   `WX^    Iio|                 		    -
;-								    -
;-	   gpWX^  `CcdCgk				    -
;-								    -
;--------------------------------------------------------------------
IDJMP
	ADD	A,A
	POP	HL
	LD	E,A
	LD	D,00
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	PUSH	DE
	POP	HL
	JP	(HL)

	PAGE
;--------------------------------------------------------------------
;-                                           ύX 1989-1-27         -
;-   LCDC_OFF   	kbcb Xgbv                	    -
;-								    -
;-	dmsqx						    -
;-	                                     			    -
;-								    -
;-	qdstqm						    -
;-	  							    -
;-								    -
;-								    -
;-	   gpWX^ `  (hda)   				    -
;-								    -
;--------------------------------------------------------------------
;
LCDC_OFF
	LD	A,(IE)
	LD	(IEB),A		; 荞݋tOޔ
	RES	0,A		; uN荞݋֎~
	LD	(IE),A
LCDC_OF10
	LD	A,(LY)		; u|ak`mj ҂
	CP	145
	JR	NZ,LCDC_OF10

	LD	A,(LCDC)	; kbcb Xgbv
	AND	%01111111
	LD	(LCDC),A

	LD	A,(IEB)
	LD	(IE),A		; 荞݋tOA
	RET


	PAGE
;--------------------------------------------------------------------
;-   RAMC     	q`l NA[				 	    -
;-								    -
;-	dmsqx						    -
;-	   gk q`l AhX                			    -
;-	   a   	                			    -
;-								    -
;-	qdstqm						    -
;-	  							    -
;-								    -
;-								    -
;-								    -
;-	   gpWX^ `, ab, gk			    	    -
;-								    -
;--------------------------------------------------------------------
;
RAMC
	LD	A,00
RAMC10
	LD	(HLI),A
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,RAMC
	RET


;--------------------------------------------------------------------
;-   V_RAMC     	u|q`l ( $9800 - $9BFF ) NA[ 	    -
;-								    -
;-	dmsqx						    -
;-	                                     			    -
;-								    -
;-	qdstqm						    -
;-	  							    -
;-								    -
;-								    -
;-	   SPACE   =   NA LN^  			    -
;-								    -
;-								    -
;-	   gpWX^ `, ab, cdCgk			    -
;-								    -
;--------------------------------------------------------------------
;
V_RAMC	LD	HL,$9FFF	; 9800-9FFF<<SPACE
	LD	BC,$800
VRC1	LD	A,SPACE

	LD	(HLD),A
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,VRC1
	RET

	PAGE
;
;--------------------------------------------------------------------
;-   DATA_MOV   	f[^ \tg ]               	    -
;-								    -
;-								    -
;-	dmsqx						    -
;-	   gk    =   ] 擪 AhX			    -
;-	   cd    =   ] 擪 AhX			    -
;-	   ab    =   ]      				    -
;-								    -
;-	qdstqm						    -
;-	  							    -
;-								    -
;-	   gpWX^ `, ab, cdCgk			    -
;-								    -
;--------------------------------------------------------------------
;
DATA_MOV
	LD	A,(HLI)
	LD	(DE),A
	INC	DE
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,DATA_MOV
	RET


DATA_MOV2
	LD	A,(HLI)
	CPL
	LD	(DE),A
	INC	DE
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,DATA_MOV2
	RET


DATA_MOV3
	LD	A,(HLI)
	LD	(DE),A
	INC	HL
	INC	DE
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,DATA_MOV3
	RET



